/*
 * Decompiled with CFR 0.152.
 */
package com.jspsmart.upload;

import com.jspsmart.upload.SmartUpload;
import com.jspsmart.upload.SmartUploadException;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.servlet.ServletException;

public class File {
    private SmartUpload m_parent;
    private int m_startData = 0;
    private int m_endData = 0;
    private int m_size = 0;
    private String m_fieldname = new String();
    private String m_filename = new String();
    private String m_fileExt = new String();
    private String m_filePathName = new String();
    private String m_contentType = new String();
    private String m_contentDisp = new String();
    private String m_typeMime = new String();
    private String m_subTypeMime = new String();
    private boolean m_isMissing = true;
    public static final int SAVEAS_AUTO = 0;
    public static final int SAVEAS_VIRTUAL = 1;
    public static final int SAVEAS_PHYSICAL = 2;

    File() {
    }

    public void saveAs(String destFilePathName) throws SmartUploadException, IOException {
        this.saveAs(destFilePathName, 0);
    }

    public void saveAs(String destFilePathName, int optionSaveAs) throws SmartUploadException, IOException {
        String path = new String();
        path = this.m_parent.getPhysicalPath(destFilePathName, optionSaveAs);
        if (path == null) {
            throw new IllegalArgumentException("There is no specified destination file (1140).");
        }
        try {
            java.io.File file = new java.io.File(path);
            FileOutputStream fileOut = new FileOutputStream(file);
            fileOut.write(this.m_parent.m_binArray, this.m_startData, this.m_size);
            fileOut.close();
        }
        catch (IOException e) {
            throw new SmartUploadException("File can't be saved (1120).");
        }
    }

    public void fileToField(ResultSet rs, String columnName) throws SQLException, SmartUploadException, IOException, ServletException {
        long numBlocks = 0L;
        int blockSize = 65536;
        int leftOver = 0;
        int pos = 0;
        if (rs == null) {
            throw new IllegalArgumentException("The RecordSet cannot be null (1145).");
        }
        if (columnName == null) {
            throw new IllegalArgumentException("The columnName cannot be null (1150).");
        }
        if (columnName.length() == 0) {
            throw new IllegalArgumentException("The columnName cannot be empty (1155).");
        }
        numBlocks = BigInteger.valueOf(this.m_size).divide(BigInteger.valueOf(blockSize)).longValue();
        leftOver = BigInteger.valueOf(this.m_size).mod(BigInteger.valueOf(blockSize)).intValue();
        try {
            int i = 1;
            while ((long)i < numBlocks) {
                rs.updateBinaryStream(columnName, (InputStream)new ByteArrayInputStream(this.m_parent.m_binArray, pos, blockSize), blockSize);
                pos = pos != 0 ? pos : 1;
                pos = i * blockSize;
                ++i;
            }
            if (leftOver > 0) {
                rs.updateBinaryStream(columnName, (InputStream)new ByteArrayInputStream(this.m_parent.m_binArray, pos, leftOver), leftOver);
            }
        }
        catch (SQLException e) {
            byte[] binByte2 = new byte[this.m_size];
            System.arraycopy(this.m_parent.m_binArray, this.m_startData, binByte2, 0, this.m_size);
            rs.updateBytes(columnName, binByte2);
        }
        catch (Exception e) {
            throw new SmartUploadException("Unable to save file in the DataBase (1130).");
        }
    }

    public boolean isMissing() {
        return this.m_isMissing;
    }

    public String getFieldName() {
        return this.m_fieldname;
    }

    public String getFileName() {
        return this.m_filename;
    }

    public String getFilePathName() {
        return this.m_filePathName;
    }

    public String getFileExt() {
        return this.m_fileExt;
    }

    public String getContentType() {
        return this.m_contentType;
    }

    public String getContentDisp() {
        return this.m_contentDisp;
    }

    public String getContentString() {
        String strTMP = new String(this.m_parent.m_binArray, this.m_startData, this.m_size);
        return strTMP;
    }

    public String getTypeMIME() throws IOException {
        return this.m_typeMime;
    }

    public String getSubTypeMIME() {
        return this.m_subTypeMime;
    }

    public int getSize() {
        return this.m_size;
    }

    protected int getStartData() {
        return this.m_startData;
    }

    protected int getEndData() {
        return this.m_endData;
    }

    protected void setParent(SmartUpload parent) {
        this.m_parent = parent;
    }

    protected void setStartData(int startData) {
        this.m_startData = startData;
    }

    protected void setEndData(int endData) {
        this.m_endData = endData;
    }

    protected void setSize(int size) {
        this.m_size = size;
    }

    protected void setIsMissing(boolean isMissing) {
        this.m_isMissing = isMissing;
    }

    protected void setFieldName(String fieldName) {
        this.m_fieldname = fieldName;
    }

    protected void setFileName(String fileName) {
        this.m_filename = fileName;
    }

    protected void setFilePathName(String filePathName) {
        this.m_filePathName = filePathName;
    }

    protected void setFileExt(String fileExt) {
        this.m_fileExt = fileExt;
    }

    protected void setContentType(String contentType) {
        this.m_contentType = contentType;
    }

    protected void setContentDisp(String contentDisp) {
        this.m_contentDisp = contentDisp;
    }

    protected void setTypeMIME(String TypeMime) {
        this.m_typeMime = TypeMime;
    }

    protected void setSubTypeMIME(String subTypeMime) {
        this.m_subTypeMime = subTypeMime;
    }

    public byte getBinaryData(int index) {
        if (this.m_startData + index > this.m_endData) {
            throw new ArrayIndexOutOfBoundsException("Index Out of range (1115).");
        }
        if (this.m_startData + index <= this.m_endData) {
            return this.m_parent.m_binArray[this.m_startData + index];
        }
        return 0;
    }
}

